clear all

* Set Folder to output one

cd ..\Outputs

* Call database of merged unemployment and real GDP growth

use vin_all, clear

* Define the matrix of long-run restrictions

matrix lr = (.,0\.,.)

local sizeofwindow=120

quiet forvalues yy=107(2)117 {

	local qq=2
	if `yy'==117 local qq=1
	
	if `yy'<100 local str0="`yy'Q`qq'"
	if `yy'>=100 & `yy'<110 {
		local yy1=`yy'-100
		local str0="0`yy1'Q`qq'"
	}
	if `yy'>=110 {
		local yy1=`yy'-100
		local str0="`yy1'Q`qq'"
	}

	* Generate empty supply and demand decomposition to fill inside the loop

	gen dlogY_BQ_supply`yy1'=.
	gen dlogY_BQ_demand`yy1'=.

	* Define growth of output and unemployment as the last available vintage

	capture drop dlogY UNR
	gen dlogY = GROUTPUT`str0'
	gen UNR   = RUC`str0'
	
	summ t if dlogY!=.
	local lastt=r(max)

	* Run the Blanchard and Quah structural VAR

	noisily di "`yy'Q`qq'"
	svar dlogY UNR if t>`=`lastt'-`sizeofwindow'', lags(1/8) lreq(lr) 
	matrix B=e(B)
	matrix invB=inv(B)
	capture drop resid*
	predict residGY, resid equation(#1)
	predict residUE, resid equation(#2)

	* Obtain structural residuals

	capture drop temp*
	gen temp_supply=invB[1,1]*residGY+invB[1,2]*residUE
	gen temp_demand=invB[2,1]*residGY+invB[2,2]*residUE
	replace temp_supply=0 if temp_supply==. & t>`lastt'
	replace temp_demand=0 if temp_demand==. & t>`lastt'

	* Create IRF file for use inside the loop

	irf create lr, set(lrirf, replace) step(100) replace

	* Store IRF to supply shock

	preserve
	use lrirf.irf, clear
	keep if response == "dlogY"
	keep if impulse  == "dlogY"
	keep step sirf
	save temp1, replace
	restore

	* Store IRF to demand shock

	preserve
	use lrirf.irf, clear
	keep if response == "dlogY"
	keep if impulse  == "UNR"
	keep step sirf
	save temp2, replace
	restore

	* Loop over time periods to generate historical decomposition

	sum t if e(sample)
	local mint=r(min)
	di "`mint'"
	local maxt=280
	di "`maxt'"
	local burn=0

	quiet forvalues period=`=`mint'+`burn''(1)`maxt' {

		noisily di "`period'"
		capture drop step
		gen step=`period'-t
		
		* Calculate historical decomposition: supply side

		joinby step using temp1, unmatched(master)
		drop _merge

		capture drop temp_dlogY_BQ_supply
		gen temp_dlogY_BQ_supply=temp_supply*sirf 
		sum temp_dlogY_BQ_supply
		replace dlogY_BQ_supply`yy1'=r(mean)*r(N) if t==`period'

		capture drop sirf

		* Calculate historical decomposition: demand side

		joinby step using temp2, unmatched(master)
		drop _merge

		capture drop temp_dlogY_BQ_demand
		gen temp_dlogY_BQ_demand=temp_demand*sirf 
		sum temp_dlogY_BQ_demand
		replace dlogY_BQ_demand`yy1'=r(mean)*r(N) if t==`period'

		capture drop sirf
		
	}
	
	sum dlogY
	replace dlogY_BQ_supply`yy1'=dlogY_BQ_supply`yy1'+r(mean)
	replace dlogY_BQ_demand`yy1'=dlogY_BQ_demand`yy1'+r(mean)
	
}

gen   time      = year+(quarter-1)/4
local base      = 2007
summ t if time==`base'
local obsofbase = r(mean)

local baseindex = 2000
local counter=1
foreach var of varlist dlogY_BQ_supply* GROUTPUT17Q1 {
	gen sap`counter'=.
	replace sap`counter'=0 if time==`baseindex'
	replace sap`counter'=sap`counter'[_n-1]+`var'/400 if sap`counter'==. & time>`baseindex'
	local ++counter
}

ds sap*

foreach var of varlist `r(varlist)' {
	gen `var'base=`var'[`obsofbase']
	replace `var'=`var'-`var'base
	drop `var'base
}

local from      = 2004
local to        = 2017

twoway ///
(line sap1 time if year>=`from' & year<=`to', lcolor(red)) ///
(line sap2 time if year>=`from' & year<=`to', lcolor(green) lpattern(dash_dot)) ///
(line sap3 time if year>=`from' & year<=`to', lcolor(blue) lpattern(dash)) ///
(line sap4 time if year>=`from' & year<=`to', lcolor(black) lpattern(shortdash)) ///
(line sap5 time if year>=`from' & year<=`to', lcolor(teal) lpattern(shortdash_dot)) ///
(line sap6 time if year>=`from' & year<=`to', lcolor(purple) lpattern(longdash)) ///
(line sap7 time if year>=`from' & year<=`to', lcolor(black) lwidth(thick)) ///	
, ///
xlabel(`from'(2)`to') xtitle("Year") ///
ylabel(-0.1(0.05)0.3) ytitle("log deviation from 2007Q1") ///
legend(	label(1 "BQ 2007") label(2 "BQ 2009") label(3 "BQ 2011") ///
		label(4 "BQ 2013") label(5 "BQ 2015") label(6 "BQ 2017") ///
		label(7 "Actual") ring(0) position(11) rows(4)) ///
graphregion(color(white)) bgcolor(white) name(sap)

save BQforplot, replace

erase temp1.dta
erase temp2.dta

rename sap1 fig14BQA1
rename sap2 fig14BQA2
rename sap3 fig14BQA3
rename sap4 fig14BQA4
rename sap5 fig14BQA5
rename sap6 fig14BQA6

keep t year quarter time fig14BQA*

save fig14BQA, replace
